// Script para ajustar el ancho de varios logos, mantener proporción,
// alinearlos horizontalmente y espaciar automáticamente.
// por @eibtools

var doc = app.activeDocument;
var sel = doc.selection;

if (sel.length > 0) {
    // Pedir ancho deseado y espacio entre logos
    var targetWidth = prompt("Ingresa el ancho deseado en píxeles:", "300");
    var spacing = prompt("Ingresa el espacio entre logos en píxeles:", "50");

    // Validar que ambos sean números válidos
    if (
        targetWidth && !isNaN(targetWidth) && targetWidth > 0 &&
        spacing && !isNaN(spacing) && spacing >= 0
    ) {
        targetWidth = parseFloat(targetWidth);
        spacing = parseFloat(spacing);

        // Ordenar objetos por posición X para mantener el orden visual
        sel.sort(function(a, b) {
            return a.visibleBounds[0] - b.visibleBounds[0];
        });

        var currentX = 0;
        var startY = sel[0].visibleBounds[1]; // Y inicial (superior)

        for (var i = 0; i < sel.length; i++) {
            var item = sel[i];
            var bounds = item.visibleBounds; // [x1, y1, x2, y2]
            var width = bounds[2] - bounds[0];
            var height = bounds[1] - bounds[3];

            // Escalar proporcionalmente
            var scale = (targetWidth / width) * 100;
            item.resize(scale, scale);

            // Nuevos límites tras escalar
            bounds = item.visibleBounds;
            var newWidth = bounds[2] - bounds[0];
            var newHeight = bounds[1] - bounds[3];

            // Mover a la posición horizontal correspondiente
            var moveX = currentX - bounds[0];
            var moveY = startY - bounds[1]; // mantenerlos alineados arriba
            item.translate(moveX, moveY);

            // Actualizar la posición X para el siguiente logo
            currentX += newWidth + spacing;
        }

        alert("✅ Logos ajustados, alineados y espaciados correctamente.");
    } else {
        alert("⚠️ Ingresa valores numéricos válidos para el ancho y el espacio.");
    }

} else {
    alert("⚠️ Selecciona al menos un logo antes de ejecutar el script.");
}
